%Achtung!! Bei den neuen Versuchen scheint die Arena bei dem mittleren
%Stimulus (der Stimulus welcher direkt hintereinander kommt) keine Pause gemacht
%zu haben daher muss eine Zeile in der Stimuliorder gel?scht werden! 

close all
close all hidden
clear all

global index
global each_isi_index
global stimphase

createfigure = 1;
runtime = clock;
timestring = ['_', ...
              num2str(runtime(1),'%.4u'), ...
              num2str(runtime(2),'%.2u'), ...
              num2str(runtime(3),'%.2u'), ...
              '_', ...
              num2str(runtime(4),'%.2u'), ...
              num2str(runtime(5),'%.2u'), ...
              num2str(runtime(6),'%02.0f')];

popuptitle = 'Instructions';
% popuptext = ['Please select the folder containing all of your .txt ', ...
%               'tracking data, as well as a single .mat file cont'];
popuptext = {'In the following pop-up window,', ...
             'please select a single existing folder.', ...
             [], ...
             'This folder should contain all of the following,', ...
             'but nothing else:', ...
             [], ...
             '- all of your .txt eye tracking data files', ...
             '- a single .mat file for stimulus orders', ...
             '- a single .xlsx file for stimulus properties'};

popup = dialog();
set(popup,'Visible','off')
set(popup, 'WindowStyle', 'modal', ...
           'Name', popuptitle, ...
           'Position', [0 0 342 190], ...
           'Color', [.2 .4 .8]);
textcontrol = uicontrol(popup);
popupposition = get(popup,'Position');
textposition = [.08*popupposition(3), ...
                .12*popupposition(4), ...
                .84*popupposition(3), ...
                .78*popupposition(4)];
set(textcontrol, 'Parent', popup, ...
                 'Style', 'text', ...
                 'Position', textposition, ...
                 'BackgroundColor', get(popup,'Color'), ...
                 'ForegroundColor', [1 1 1], ...
                 'FontSize', 15, ...
                 'HorizontalAlignment', 'left', ...
                 'String', popuptext);
set(popup, 'Visible', 'on')
disp('--- To continue, please read and close the instructions pop-up. ---')
uiwait(popup)
disp('--- Thanks! Moving on. ---')
startpath = '/Users/florian/Dropbox (Personal)/MATLAB/Rebecca datenanalyse20171214/Sphere data analysis 201801/rawdatafolder';
dialoghint = 'Please select data folder.';
foldername = uigetdir(startpath,dialoghint);

txtfilenamelist = dir([foldername,'/*.txt']);
matfilenamelist = dir([foldername,'/*.mat']);
xlsxfilenamelist = dir([foldername,'/*.xlsx']);

if numel(txtfilenamelist) == 0
  error('No .txt files located in this folder. Restart, and choose another.')
end
if numel(matfilenamelist) == 0
  error('No .mat file located in this folder. Restart, and choose another.')
end
if numel(xlsxfilenamelist) == 0
  error('No .xlsx file located in this folder. Run again, and choose another.')
end
if numel(matfilenamelist) > 1
  error(['More than one .mat file may be located in this folder. ', ...
         'Run again, and choose another. If this is NOT the case, ', ...
         'check if file is already open in another application, ', ...
         'close it, and run again.'])
end
if numel(xlsxfilenamelist) > 1
  error(['More than one .xlsx file may be located in this folder. ', ...
         'Run again, and choose another. If this is NOT the case, ', ...
         'check if file is already open in another application, ', ...
         'close it, and run again.'])
end

numtxtfile = numel(txtfilenamelist);
matfilename = matfilenamelist.name;
xlsxfilename = xlsxfilenamelist.name;

matfilecontent = load([foldername,'/',matfilename]);
matfilefieldname = fieldnames(matfilecontent);
stimulusordertable = matfilecontent.(matfilefieldname{1});
if numel(matfilefieldname) > 1 || ~isfloat(stimulusordertable)
  error('.mat file should contain only a single numerical matrix. Its variable name does not matter.')
end

stimulustype.index       = xlsread([foldername,'/',xlsxfilename],'B:B');
stimulustype.azimuth     = xlsread([foldername,'/',xlsxfilename],'C:C');
stimulustype.elevation   = xlsread([foldername,'/',xlsxfilename],'D:D');
stimulustype.radius      = xlsread([foldername,'/',xlsxfilename],'E:E');
stimulustype.tempfreq    = xlsread([foldername,'/',xlsxfilename],'F:F');
stimulustype.spatialfreq = xlsread([foldername,'/',xlsxfilename],'G:G');
stimulustype.maxvelocity = xlsread([foldername,'/',xlsxfilename],'H:H');
stimulustype.framerate   = xlsread([foldername,'/',xlsxfilename],'I:I');
stimulustype.period      = xlsread([foldername,'/',xlsxfilename],'J:J');

% analoginput

numstimulusorder = max(max(stimulusordertable));
numstimulustype = size(stimulustype.index,1);

% if numtxtfile > numstimulusorder
%   error(['The .mat file for stimulus sequences contains FEWER ', ...
%          'individual sequences than there are data files in this ', ...
%          'folder. Are you sure these are the correct files?'])
% elseif numtxtfile < numstimulusorder
%   warning(['The .mat file for stimulus sequences contains MORE ', ...
%            'individual sequences (',num2str(numstimulusorder),') than there ', ...
%            'are data files in this folder (',num2str(numtxtfile),'). ', ...
%            'Are you sure these are the correct files? ', ...
%            'The analysis will work nonetheless, using only the first ', ...
%            num2str(numtxtfile),' sequences in the .mat file, and omit ', ...
%            'the remaining ',num2str(numstimulusorder-numtxtfile)])
% else
%   disp(['Found ',num2str(numtxtfile),' data files, and the same '])
% end

if max(max(stimulusordertable))+1 > numstimulustype
  error('.mat file refers to stimulus indices not included in the .xlsx file.')
end

data = struct;

numfish = numtxtfile;

for fish = 1:numfish
  
  data(fish).stimulusorder = stimulusordertable(:,fish);
  data(fish).txtfilename = txtfilenamelist(fish).name;
  
  data(fish).raw = load([foldername,'/',data(fish).txtfilename]);
  
  %   txtfilename.stimulus = stimulus
%     [order.txtfilename, order.foldername, ~] = uigetfile('*.txt');
%   data(fish).stimulusorder = sequence.WHfDLfDRfDRbDLbHbW(:,4)';
  %[~,~,position] = xlsxread('Stimulusprotokolle.xlsx','B105:AR108');
  
  absolutetime      = data(fish).raw(:,1);
  anglelefteye      = data(fish).raw(:,5);
  anglerighteye     = data(fish).raw(:,6);
  analoginput       = data(fish).raw(:,7);
  xpositionlefteye  = data(fish).raw(:,8);
  ypositionlefteye  = data(fish).raw(:,9);
  xpositionrighteye = data(fish).raw(:,10);
  ypositionrighteye = data(fish).raw(:,11);
  
  relativetime = absolutetime - absolutetime(1);
  
  for eye = 1:2 % 1 is left, 2 is right
    
    if eye == 1
      
      angle = anglelefteye;
      xposition = xpositionlefteye;
      yposition = ypositionlefteye;
      
    elseif eye == 2

      angle = anglerighteye;
      xposition = xpositionrighteye;
      yposition = ypositionrighteye;
      
    else
      
      error('Fish should not have more than two eyes, or less than one...')
      
    end
   
    % Repetition tracker must be located here to reinitialise for each fish
    % and eye.
    repetitiontracker = zeros(numstimulustype,1);

    % Digitalise analog input signal to then detect stimulus presentation.
    digitalisedinput = analoginput > 0;

    % Der erste und der zweite Wert von digitalisedinput wird durch 1 und 0 ersetzt,
    % damit am Anfang der Aufnahme eine Ver?nderung stattfindet. Dies dient
    % dazu um den sp?teren Startpunkt der erstem Stimulusphase zu
    % identifizieren, da der Code davon ausgeht, dass der Anfang einer 
    % Stimulusphase dass Ende einer "Pause" ist. Diese Pause besteht selbst 
    % aus einem Anfang und einem Ende einer Stimulusphase. DIe 1 und 0 die
    % eingef?hrt werden stellen sicher , dass auf jeden fall ein solcher Anfang
    % vorhanden ist.
    digitalisedinput(1) = 1; 
    digitalisedinput(2) = 0;

    inputflip = diff(digitalisedinput)~=0;
    inputflipindex = [];
    for k = 1:size(inputflip)
        if inputflip(k) == 1
        inputflipindex = [inputflipindex k]; %#ok<AGROW>
        end
    end
    trialend = size(analoginput,1);
    inputflipindex = [inputflipindex trialend]; %#ok<AGROW>
    changeindexdifference = diff(inputflipindex);

    threshold_sacc = 30;
    stimlength = 80; % dieser Wert sollte unter der eigentlichen Stimulusl?nge liegen (sek)
    endindex = [];
    startindex = [];
    for k = 1:size(changeindexdifference,2)
        if changeindexdifference (k) > threshold_sacc 
         endindex = [endindex, inputflipindex(k)];
             if k < size(changeindexdifference,2)
                startindex = [startindex, inputflipindex(k+1)];
             end
        end
    end
        
%     % XXX ad-hoc bug fix, only relevant for incomplete data files
%     if numel(startindex) == numel(endindex)
%       startindex(end) = []
%     end

    endindex = endindex(2:end);
    starttime = absolutetime(startindex);
    endtime = absolutetime(endindex);

    meaningful = endtime - starttime > 0.6* stimlength; % hier wird nocheinmal abgefragt ob es sich tats?achlich um eine Pauser der gew?nschten L?nge handelt
    starttime = starttime(meaningful);
    endtime = endtime(meaningful);
    startindex = startindex(meaningful);
    endindex = endindex(meaningful);

    if createfigure
      
      % Verlauf des Stimulus wird geplottet (nur zur Kontrolle)
      figure(888)
      plot(absolutetime,analoginput)
      hold on
      plot([starttime, starttime]', repmat([0,5],numel(starttime),1)','linewidth', 3, 'color', 'r' )
      plot([endtime endtime]', repmat([0,5],numel(starttime),1)',':','linewidth', 3, 'color', [1 .5 .5])
      hold off
      
    end


    % test for headmovement and cut them out. But check for noiselevel and if
    % nessecary adjust!
    % checking if it is just an eyemovement or if the whole fish moved
    max_movement_of_eyes = 20;
    threshold_move_plus = 10; %check for noise level and then adjust
    threshold_move_minus = -10;


    for k = 1:size(xposition,1) 
    abstand(k) = sqrt(((xposition(k)-(xposition(1)))^2)+(((yposition(k)-(yposition(1)))^2)));
    end

    window_med = 200;
    for k = 1:size(abstand,2)
        von =max(1,k-window_med);           %!!!!!!!!!!!!!!!!!!!!! <3
        bis =min(numel(abstand),k+window_med);
    median_abstand(k) = median(abstand(von:bis));
    end
    movement = abstand-median_abstand;
    headmoveindex = [];
    %ab = (diff(angle_left)./ diff(data(fish).time)); %velocity 

    if createfigure

      % check noise level
      figure(222)
      plot(movement)

    end

    for k = 1:size(movement,2)
    if movement(k) >= threshold_move_plus || movement(k) <= threshold_move_minus
        headmoveindex = [headmoveindex k];
    end
    end

    % cut headmovement
    cut_headmovement = 30; % um dieses Fenster wird geschnitten

    for k = 1:size(headmoveindex,2)
    angle(headmoveindex(k):cut_headmovement) = NaN;
    end

    % find saccades and cut them out of the angle
     threshold_sacc = 2.5; % check here figures if the treshold is setted correctly
     threshold_sign = 2;
     threshold_med = 1;
     threshold_change = 1;
     threshold_change_and_sign = 2;
     % Hier wird die Gr??e des zu untersuchenden Fensters bestimmt
     window_sacc = 50; 
     window_past = 5;
     window_cut_future = 20; % Um diesen Wert wird geschnitten


    candidateindex =[];
    max_index_pos =size(angle,1);
    for k = 1:size(angle,1)
      max_argument = size(angle,1);
      argument = min(k+(1:window_sacc),max_argument);
      argument_past = max((k-window_past:k),1);
      future_window_pos = angle(argument);
      past_window_pos = angle(argument_past);
      sign_sacc = sign(diff([angle(k) angle(min(k+1,max_argument))]));
      sign_window_future = sign(diff(future_window_pos));
      sign_window_past = sign(diff(past_window_pos));
      sign_window_compare_past = sign_sacc./sign_window_past;
      sign_window_compare_future = sign_sacc-sign_window_future;
      first_sign_change = min(find(sign_window_compare_future));
      criterion_sign_future_pos = (abs(angle(k+first_sign_change)-angle(k))) > threshold_sacc;
      criterion_sign_past_pos = (sign_window_compare_past(end)< 0) && (sum(sign_window_compare_past(1:end-1)==-1) <=1);

        if criterion_sign_future_pos == 1
            if criterion_sign_past_pos == 0
            candidateindex = [candidateindex k];
            end
        end


    end

      % We have to make sure we don't count the same (prolonged) saccade twice.
      % Remove these apparent, but meaningless, additional saccade times.
      exclusiontime = 4;
      fakesaccades =find(diff(candidateindex) < exclusiontime);
      fakesaccades = fakesaccades + 1;
      candidateindex(fakesaccades) = [];

    % cut saccade
    cut_here = 2;
    max_argument = size(angle,1);
    end_cut_save = [];   
    for k = 1:size(candidateindex,2)

        sign_sacc_cut = sign(diff([angle(candidateindex(k)), ...
            angle(min(candidateindex(k)+1,max_argument))]));

        argument_cut = min(candidateindex(k)+(1:window_cut_future),max_argument);
        sign_window_cut_future_pos = sign(diff(angle(argument_cut)));
        sign_window_compare_future_cut = sign_sacc_cut-sign_window_cut_future_pos;
        sign_change_cut =find(sign_window_compare_future_cut);
    %     if candidateindex(i)+cut_here >= numel(angle)
    %       end_cut = numel(angle);
        if numel(sign_change_cut)< cut_here % cut_here beshcreibt die Anzahl der Vorzeichenwechsel
            end_cut = argument_cut (end);
        else
            nth_sign_change_cut = sign_change_cut(cut_here);
            end_cut = candidateindex(k)+nth_sign_change_cut;
        end
        if end_cut > numel(angle)  %Sollte end_cut gro?er sein als der datensatz wird der letzte Wert angepasst
          end_cut = numel(angle);
        end
        end_cut_save = [end_cut_save end_cut];


    end

    % Zuvor bestimmte Saccaden werden herausgeschnitten
    for k = 1: size(end_cut_save,2)
      angle(candidateindex(k):end_cut_save(k)) = NaN;
    end
      candidatetime= absolutetime(candidateindex);

      data(fish).eyepos_cut = struct; 



    numbersacc = candidateindex;
    numbersacc(numbersacc<= startindex(1)) = [];
    numbersacc(numbersacc>= endindex(1)) = [];
    sacc1 = numel (numbersacc);


    numbersacc2 = candidateindex;
    numbersacc2(numbersacc2<= startindex(end)) = []; % max l?nge. Vll einfach end schreiben?...
    %Muss jedes Mal justiert werden. 89 ist hier die Anzahl der Stimphasen
    numbersacc2(numbersacc2>= endindex(end)) = [];
    sacc2 = numel (numbersacc2);

% data(fish).stimulusorder
        for k = 1:size(startindex,2)

          eyeposindex= 1:size(angle,1);   
          eyeposindex_each_stim{k} = eyeposindex(startindex(k): endindex(k));

          test = (diff(angle(startindex(k): endindex(k))));
          testzeit =(diff(absolutetime(startindex(k): endindex(k))));
          data(fish).velocity = test./ testzeit;
          cellindex = data(fish).stimulusorder(k)+1;

          %figure out which stimuli phase was presented here
          %print the degrees associated with this stimulus phase

          % left eye description of stimulie phases
    %       type = num2str(position{2,cellindex});
    %       typesave=type;
    %       a = strfind(typesave,' ');
    %       typesave(a) = [];
    %       alpha = num2str(position{3,cellindex});
    %          if strcmp (alpha,'NaN')
    %          alpha = '';
    %          end
    %       beta = num2str(position{4,cellindex});
    %          if strcmp (beta,'NaN')
    %          beta = '';
    %          end
    %          if data(fish).stimulusorder(i) ~= position{1,cellindex}
    %          error('Die sind gar nicht gleich...')
    %          end
    %       number = num2str(position{1,cellindex});

    %       alphasave = alpha;
    %       b = strfind(alphasave,'.');
    %       b2 =strfind(alphasave,'-');
    %       alphasave(b) = 'p';
    %       alphasave(b2) = 'm';
    % 
    %       betasave = beta;
    %       c = strfind(betasave,'.');
    %       c2 =strfind(betasave,'-');
    %       betasave(c) = 'p';
    %       betasave(c2) = 'm';
    %    
    %    
    %       label = {'left eye';[type ' ' number]; alpha; beta};
    %       labelsave = ['left_eye_',typesave, '_', number,'_',alphasave, '_',betasave];
    % 
    %  
    %       data(fish).eyepos_cut= setfield(data(fish).eyepos_cut, labelsave, angle(startindex(i): endindex(i)));  

    
          % Stimulus parameters
          stimtype = data(fish).stimulusorder(k) + 1; % plus one because first stimulus has index zero
          %stimtype = data(fish).stimulusorder(k);
          wahreperiodenlaenge = stimulustype.period(stimtype);
          vel_peak2 = stimulustype.maxvelocity(stimtype);
          framerate = stimulustype.framerate(stimtype);
          step = 1/framerate;
          vel_peak=vel_peak2/framerate;
          frequenz = 1/wahreperiodenlaenge;
          freq_stim = frequenz;
    
          
          n = (endtime(k)-starttime(k));
          komischeperiodenlaenge = n/wahreperiodenlaenge;
          benutzteeperiodenlaenge = wahreperiodenlaenge;
          x1=(starttime(k):step:endtime(k));
          x2 = x1-starttime(k);

          vel = vel_peak* sin(2*pi*x2/benutzteeperiodenlaenge)+ angle(startindex(k));
          vel2 = (vel_peak* sin(2*pi*x2/benutzteeperiodenlaenge));
          %vel3(abs(vel2)<0.04) = 0;
          %vel_zero = find(vel2==0);
          %vel_idata(fish).eyepos_cut (vel_zero)

    for k = 1:10
      vel_zero(2*k) = (k-1)*benutzteeperiodenlaenge+(benutzteeperiodenlaenge/2);
      vel_zero(2*k-1) = (k-1)*benutzteeperiodenlaenge;
    end

    vel_zero_all = [vel_zero (vel_zero(end)+benutzteeperiodenlaenge/2)];
    vel_zero_time(k,:) = vel_zero_all;


    % plot eyemovement ans sinus in each stimulie as its own 
           %figure (0+i)
    %       hold on
    %       plot(eyetime(startindex(i): endindex(i)),angle(startindex(i): endindex(i)),'color', 'b')
          %plot(x,vel,'r')
    %       text (.9,.9,label,'units', 'normalized')
    %       hold off

    %Berechnung f?r Mittlere Augenpos
    relevantangle = angle(startindex(k): endindex(k));
    relevantangle(isnan(relevantangle)) = [];
    med_stimphase (k) = median(relevantangle);
       end
    % 
    %   velocity calculating 
    %    for  t = 1:  size(saccadetime_left) 
    %        indexsaccade_left(t) = find(data(fish).time==saccadetime_left(t))
    % %        crop = angle(indexsaccade(t-1) : indexsaccade(t))
    %    end
    %    
    % 
    %    for t = 2 :numel(indexsaccade_left) 
    %         crop = angle(indexsaccade_left(t-1) : indexsaccade_left(t))
    %    end
    %  
    % 
    % 
    % 
    % Finally, plot detected saccade times for visual inspection.
    % if strcmp (plot_saccade_detection,'yes')

    if createfigure
      
      %eye whole eyemovement with saccades and headmovement
%       figure(212)
%       set(gcf,'Color',[1 1 1],'Position',[10 10 1200 300],'Name','Eye position')
%       axes('Position',[.04 .15 .94 .8])
%       hold on
%       plot(absolutetime([1 end]),[0 0],'-k')
%       plot(absolutetime,angle,'Color',[.2 .4 .8])
%       yrange = get(gca,'YLim');
%       for k = 1:numel(candidatetime)
%       plot(candidatetime(k)*[1 1],yrange,'--','Color',[.8 .0 .0])
%       end
% %       if headmoveindex ~= 0
% %       plot(absolutetime(headmoveindex)*[1 1],yrange,'--','Color',[.5 .5 .0])
% %       end
%       hold off
%       set(gca,'XLim',absolutetime([1 end]),'TickLength',[0 0])
%       xlabel('time since trial onset  (sec)')
%       ylabel('eye position  (degrees)')
%       box on
%       
     end

      %Fitting

     each_isi_index = cell(1);
     angle_move = NaN(size(angle));
    for stimphase = 1:numel(eyeposindex_each_stim)
    %for stimphase = [1]


        %display(stimphase)

        index = eyeposindex_each_stim{stimphase};
        eyepos_phase_stim = angle(index);
        eyetim_phase_stim = absolutetime(index);
        a = ~isnan (eyepos_phase_stim); % alle 1 und 0 einer phase
        index_windows = find(diff(a))+(index(1)-1);

        % a(...) == 1 means there is slow-phase motion; == 0 means saccade/cut
        if a(1) == 1 && a(end) == 1
          endpoint = index_windows(1:2:end)';
          endpoint = [endpoint index(end)];
          startpoint = index_windows(2:2:end)';
          startpoint =[index(1) startpoint];
        elseif a(1) == 0 && a(end)==1
          endpoint = index_windows(2:2:end)';
          endpoint = [endpoint index(end)];
          startpoint = index_windows(1:2:end)';
        elseif a(1)== 0 && a(end)==0
          endpoint = index_windows(2:2:end)';
          startpoint = index_windows(1:2:end)';
        elseif a(1)== 1 && a(end)== 0
          endpoint = index_windows(1:2:end)';
          startpoint = index_windows(2:2:end)';
          startpoint =[index(1) startpoint];
        end


        %startpoint_phase = [index(1) startpoint_phase];
        %endpoint_phase = [endpoint_phase index(end)];

         for isi = 1:size(startpoint,2)
            each_isi_index{stimphase,isi} = startpoint(isi):endpoint(isi);
            y_croptsin{isi} =angle(each_isi_index{stimphase,isi});
            x_croptsin{isi} = absolutetime(each_isi_index{stimphase,isi});

         end

% XXX
%          frequenz = 0.1; % Bestimmung des Startwertes
         beta0_freq_phase = [frequenz,0];
         beta0_offset = 0*ones(1,numel(each_isi_index(stimphase,:)));
         beta0_amp = 100; % Bestimmung des Startwertes

        %beta0 = [1, 0, 0*ones(1,size(each_isi_index,2))];

         y = angle(index);
         x = absolutetime(index);
         %y(isnan(y))=0;
         options.MaxIter = 1e6;
         options.TolFun = 1e-12;
         options.TolX = 1e-12;

         beta_all = [beta0_amp, beta0_freq_phase(2),beta0_offset , beta0_freq_phase(1)];
         %save (['C:\Users\Reb\Documents\MATLAB\Data & Code 110117\290916_',num2str(stimphase)],'beta_all')

         % Sollte man zus?tzliche Sicherheit bim Fitten haben m?chten kann man
         % ebenfalls Phase, Offset und Amplitude einzeln vorher Fitten

    %       for i = 1:1
    %      beta_freq_phase = nlinfit(x,y,@fitsin_freq_phase_stimphases, beta_all([end 2]));
    %      beta_all([end 2]) = beta_freq_phase;
    %      beta_offset = nlinfit(x,y,@fitsin_offset_stimphases, beta_all(3:end-1));
    %      beta_all(3:end-1) = beta_offset;
    %      beta_amp = nlinfit(x,y,@fitsin_amp_stimphases, beta_all(1));
    %      beta_all(1) = beta_amp;
    %       
    %       end



    % Hier k?nnen verschiedene Optionen f?r das Fitting eingestellt werden

    %      options.MaxIter = 1e6;
    %      options.TolFun = 1e-12;
    %      options.TolX = 1e-12;   

    % Sollte man vorher einzelne Parameter gefitted haben k?nnen sie hier in
    % den "Endfit" als beta0 eingegeben werden.

         %beta0 = [beta_amp, beta_freq_phase(2),beta_offset , beta_freq_phase(1)];
         %beta = nlinfit(x,y,@fitsin, beta0,options);

    % Sollte man vorher keine Parameter gefitted haben kann man hier die vorher
    % festgelegeten Startwerte benutzen bzw Optionen beutzen

         beta = nlinfit(x,y,@fitsin_all_stimphases, beta_all);
         disp(['Currently fitting phase ',num2str(stimphase),' of ', ...
               num2str(numel(data(fish).stimulusorder)),' (fish ', ...
               num2str(fish),' of ',num2str(numfish),').'])
         %beta = nlinfit(x,y,@fitsin, beta0(1:end),options);

    % Berechnug des Gains, Frequenz und der Phase in Sekunden
%          freq_stim = 0.1;
% XXX
         amp = beta(1);
         gain = abs(amp)/(vel_peak2/(freq_stim*2*pi)); 
         frequ = beta(end);
         if amp < 0
         phase = (beta(2)+180);
         else phase = beta(2);
         end
         phase = mod(phase,360);
         phase_sec = phase/(360*frequ);


    %Ersetzen der NaNs im FIT (f?r sp?teres Berechnen von R-Square)
     yfit = fitsin_all_stimphases(beta,x);

     withoutnan = find(~isnan(y) .* ~isnan(yfit));
     y_wo_Nan = y(withoutnan);
     yfit_wo_Nan = yfit(withoutnan);

    % Berechnung von R-Square (Problem gute Werte nahe 1 auch f?r sehr
    % schlechte fits)
    rsquare = 1- ( sum( (y_wo_Nan-yfit_wo_Nan).^2 ) / sum( (y_wo_Nan-mean(y_wo_Nan)).^2) );



        %das folgende ist ad-hoc fuers lab meeting
        if phase_sec > 9
          phase_adhoc = phase_sec - 1/frequ;
        else
          phase_adhoc = phase_sec;
        end

        %fisch1_left(stimphase,:) = [gain, frequ, phase_adhoc];

        offset{stimphase} =  beta(3:end-1);

    %     cellindex = data(fish).stimulusorder(stimphase)+1;
    %           type = num2str(position{2,cellindex});
    %       typesave=type;
    %       ab = strfind(typesave,' ');
    %       typesave(ab) = [];
    %       alpha = num2str(position{3,cellindex});
    %          if strcmp (alpha,'NaN')
    %          alpha = '';
    %          end
    %       beta5 = num2str(position{4,cellindex});
    %          if strcmp (beta5,'NaN')
    %          beta5 = '';
    %          end
    %          if data(fish).stimulusorder(stimphase) ~= position{1,cellindex}
    %          error('Die sind gar nicht gleich...')
    %          end
    %       number = num2str(position{1,cellindex});
    % 
    %       alphasave = alpha;
    %       b = strfind(alphasave,'.');
    %       b2 =strfind(alphasave,'-');
    %       alphasave(b) = 'p';
    %       alphasave(b2) = 'm';
    % 
    %       betasave = beta5;
    %       c = strfind(betasave,'.');
    %       c2 =strfind(betasave,'-');
    %       betasave(c) = 'p';
    %       betasave(c2) = 'm';
    %     label = {[type ' ' number]; alpha; beta5};

    %         figure (0+stimphase)
    %        hold on
    %        plot(eyetime(index),angle(index),'color', 'b')
    %        plot(eyetime(index),yfit,'LineWidth',3)
    %        plot(eyetime(index),ones(size(eyetime(index))) * amp,'-g','LineWidth',2)
    % %        plot(eyetime(startindex(stimphase): endindex(stimphase)),yfit,'LineWidth',3)
    % %        plot(eyetime(startindex(stimphase): endindex(stimphase)),angle(startindex(stimphase): endindex(stimphase)),'color', 'r')
    %       %plot(x,vel,'r')
    %        text (.9,.9,label,'units', 'normalized')
    %        text (.1,.9,num2str(gain),'units', 'normalized')
    %        text (.1,.8,num2str(frequ),'units', 'normalized')
    %        text (.1,.7,num2str(phase_adhoc),'units', 'normalized')
    %        hold off

    %verschieben der Daten um den jeweiligen Offset
         for isi = 1:size(startpoint,2)
           %k = max(size(offset));
            %each_isi_index{stimphase,isi} = startpoint(isi):endpoint(isi);
            angle_move(each_isi_index{stimphase,isi})=angle(each_isi_index{stimphase,isi})-offset{stimphase}(isi);
            %angle_move(each_isi_index{stimphase,isi})=angle(each_isi_index{stimphase,isi})-offset{k}(isi);
            eyepos_zero_index = min(abs(angle_move));
         end
         %name = {'290916', '051016b','051016d', '061016a','061016b','141116','151116','181116c','181116d','291116','kontrolle'};
         %Name zum speichern
%            name_input = '03112017_6dpf_script4_rl_2';
           name_input = txtfilenamelist(fish).name;

        if createfigure

           % Plotten jeder einzelnen Stimphase inclusive Fit zur optsichen
           % Kontrolle
           h = figure (fish*100+stimphase);
           hold on
           plot(absolutetime(startindex(stimphase): endindex(stimphase)),angle(startindex(stimphase): endindex(stimphase)),'color', 'b')
           plot(absolutetime(startindex(stimphase): endindex(stimphase)),angle_move(startindex(stimphase): endindex(stimphase)),'color', 'r')
           plot(absolutetime(index),yfit,'LineWidth',3)
           plot(absolutetime(index),ones(size(absolutetime(index))) * abs(amp),'-g','LineWidth',2)
           %hold off
           %text (.9,.9,label,'units', 'normalized')
           text (.1,.9,['Gain = ',num2str(gain)],'units', 'normalized')
           text (.9,.8,['R^2 = ',num2str(rsquare)],'units', 'normalized')
           text (.5,.9,name_input,'units', 'normalized')
           %title('Beispiel eines Fittes','FontSize',18)
           xlabel('Zeit [s]','FontSize',14)
           ylabel('Augenposition [?]','FontSize',14)
           set(gcf, 'position', [0 0 1000 600])
           
%            % VERSION DEPEDENT FUNCTION!!! XXX
%            % Speichern der einzelnen Abbildungen
          if eye == 1
            savefig(h,[num2str(fish),'_',num2str(stimphase),'_left'])
            saveas(gcf,[num2str(fish),'_',num2str(stimphase),'_left'],'png')
          end
          if eye == 2
            savefig(h,[num2str(fish),'_',num2str(stimphase),'_right'])
            saveas(gcf,[num2str(fish),'_',num2str(stimphase),'_right'],'png')
          end
            delete(h)
         

        end

        stimtype = data(fish).stimulusorder(stimphase) + 1; % plus one because first stimulus has index zero
        %stimtype = data(fish).stimulusorder(stimphase)
        repetitiontracker(stimtype) = repetitiontracker(stimtype) + 1;
        repetition = repetitiontracker(stimtype);

         %Speichern
         result(fish,eye,stimtype,repetition).gain = gain;
         result(fish,eye,stimtype,repetition).freq = frequ;
         result(fish,eye,stimtype,repetition).phase = phase_adhoc;
         result(fish,eye,stimtype,repetition).offset = offset;
         result(fish,eye,stimtype,repetition).yfit = yfit;
         result(fish,eye,stimtype,repetition).y_raw = y;
         result(fish,eye,stimtype,repetition).x_raw = x;
         %result(fish,eye,stimtype,repetition).label = label;
         result(fish,eye,stimtype,repetition).beta = beta_all;
         result(fish,eye,stimtype,repetition).rsquare = rsquare;
         result(fish,eye,stimtype,repetition).sacc_treshold = threshold_sacc;
%          result(fish,eye,stimphase).stimulusorder = data(fish).stimulusorder;
         result(fish,eye,stimtype,repetition).txtfilename = name_input;
         result(fish,eye,stimtype,repetition).eye_posmove = angle_move(startindex(stimphase): endindex(stimphase));
         result(fish,eye,stimtype,repetition).stimphase = stimphase;
         result(fish,eye,stimtype,repetition).stim_velo = vel2;
         result(fish,eye,stimtype,repetition).candidateindex_sacc = candidateindex;


    end
    subfoldername = [foldername,'/result',timestring];
    if ~isdir(subfoldername)
      mkdir(subfoldername)
    end
    resultfilepath = [subfoldername,'/result',timestring,'.mat'];
%     resultfilepath = [subfoldername,'/',name_input(1:end-4),'.mat'];
    if exist(resultfilepath,'file')
      save(resultfilepath,'result','-append')
    else
      save(resultfilepath,'result')
    end

%     save ([subfoldername,'/',name_input '130617_42_right'],'rawdata')
    % Zuordnung der einzelnen Stimulusphasen (Achtung bei den neuen Experimenten so nicht m?glich da ein der Mitte keine Pausen gemacht wurde)

    % for k = 2:numel(data(fish).stimulusorder)
    %   repetition(k) = 1+numel(find(data(fish).stimulusorder(1:(k-1))==data(fish).stimulusorder(k)));
    % end
    % repetition(1)=1;
    % for j = 1:numel(data(fish).stimulusorder)
    %   data(data(fish).stimulusorder(j)+1,repetition(j))= rawdata(j);
    % end


     %save (['C:\Users\Reb\Documents\MATLAB\neue Veruche 13102017\',name_input],'data')
   
  end
end